ORCA/M Asm65816 2.1.0

0001 40A0                       title 'DefProcs' 
0002 40A0              **********************************************************************
0003 40A0              *
0004 40A0              * Control Manager Def Procs
0005 40A0              *
0006 40A0              * Copyright (C)
0007 40A0              * Apple Computer, Inc. 1986-1992
0008 40A0              * All Rights Reserved
0009 40A0              *
0010 40A0              * 4-Jan-91          Dave Lyons
0011 40A0              *
0012 40A0              * Changed scroll bar NewValue routine (move_thumb) to delay until minScrollTicks
0013 40A0              * have passed since the last scroll bar NewValue message.  This maxes out the
0014 40A0              * scrolling speed for souped-up machines.
0015 40A0              *
0016 40A0              * 6-Jan-91          Dave Lyons
0017 40A0              *
0018 40A0              * Changed the scroll bar delay thing to use WaitUntil in misc tools.
0019 40A0              *
0020 40A0              * 21-Apr-91         Dave Lyons
0021 40A0              *
0022 40A0              * Added a missing SEC in draw_icon (for scroll bar bug).
0023 40A0              *
0024 40A0              * 9-Dec-91          Dave Lyons
0025 40A0              *
0026 40A0              * Scroll_init calls CtlNewRes to force computation of the new pattern/color
0027 40A0              * for the thumb area (gray if available, checkerboard if not).
0028 40A0              *
0029 40A0              * Scroll_draw checks bit 6 of the scroll bar's ctlFlag; if set, the bar
0030 40A0              * is part of an extended list control (handle in the refcon), so it calls
0031 40A0              * CallCtlDefProc and feeds the list the ctlChangeTarget message so that
0032 40A0              * the focus frame is always redrawn.
0033 40A0              *
0034 40A0              * 9-Jan-92          Dave Lyons
0035 40A0              *
0036 40A0              * Set a valid port around the CtlNewRes call in the scroll bar defproc.
0037 40A0              *
0038 40A0              * 6-Feb-92          Dave Lyons
0039 40A0              *
0040 40A0              * Scroll bar preserves [<data],State around CallCtlDefProc when notifying
0041 40A0              * an extended List control to redraw the focus frame.
0042 40A0              *
0043 40A0              **********************************************************************
0044 40A0
0045 40A0                       string asis 
0046 40A0                       blanks off 
0047 40A0
0048 40A0                       print push 
0049 40A0                       print off 
0050 40A0
0051 40A0                       include 'all.macros' 
0052 40A0                       include 'equates.asm' 
0053 40A0                       include 'superequates.asm' 
0054 40A0                       include 'e16.event' 
0055 40A0
0056 40A0                       print pop 
0057 40A0
0058 40A0
0059 40A0              ;====================================================================
0060 40A0              ;
0061 40A0              ;          Return Null
0062 40A0              ;
0063 40A0              ;====================================================================
0064 40A0              null_ret proc EXPORT 
0065 40A0              ;
0066 40A0 A9 00 00              lda   #0                       Nothing flag.
0067 40A3 AA                    tax   
0068 40A4
0069 40A4 60                    rts   
0070 40A5
0071 40A5                       ENDP 
0072 40A5
0073 40A5
0074 40A5              ;====================================================================
0075 40A5              ;
0076 40A5              ;          Invals bounding rect of control
0077 40A5              ;
0078 40A5              ;   IN:    ctlPtr
0079 40A5              ;
0080 40A5              ;  OUT:    a and x = 0
0081 40A5              ;
0082 40A5              ;====================================================================
0083 40A5              Inval_rect proc 
0084 40A5
0085 40A5 A5 05                 lda   ctlPtr
0086 40A7 18                    clc   
0087 40A8 69 08 00              adc   #NewCtlRecord.ctlRect
0088 40AB AA                    tax   
0089 40AC A5 07                 lda   ctlPtr+2
0090 40AE 69 00 00              adc   #0
0091 40B1 48                    pha   
0092 40B2 DA                    phx   
0093 40B3 A2 0E 3A 22           _InvalRect 
0094 40BA
0095 40BA
0096 40BA AA                    tax   
0097 40BB
0098 40BB 60                    rts   
0099 40BC
0100 40BC                       ENDP 
0101 40BC
0102 40BC
0103 40BC              ;====================================================================
0104 40BC              ;
0105 40BC              ;          Print an icon.
0106 40BC              ;
0107 40BC              ;   IN:    x = icon number.
0108 40BC              ;          state = hilite state.
0109 40BC              ;          rect = where to print.
0110 40BC              ;
0111 40BC              ;====================================================================
0112 40BC              print_icon proc EXPORT 
0113 40BC
0114 40BC A0 50 00              ldy   #state
0115 40BF B7 41                 lda   [<data],y
0116 40C1 F0 05                 beq   ok1
0117 40C3
0118 40C3 8A                    txa   
0119 40C4 09 01 00              ora   #1                       Use hilited version of icon.
0120 40C7 AA                    tax   
0121 40C8              ;
0122 40C8 8A           ok1      txa   
0123 40C9              ;
0124 40C9              ;
0125 40C9                       EXPORT draw_icon 
0126 40C9              draw_icon                               ;
0127 40C9 85 2D                 sta   <work                    Store icon (character) number.
0128 40CB 20 8E 37              jsr   get_csize2               Get icon's size.
0129 40CE              ;
0130 40CE A5 19                 lda   <rect+y2                 Center icon vertically in 'rect'.
0131 40D0 38                    sec   
0132 40D1 E5 15                 sbc   <rect+y1                 Height of button.
0133 40D3 A0 21 00              ldy   #rect2+y2
0134 40D6              *** added 21-Apr-91 DAL -- draws icon in correct location if top coord is negative
0135 40D6 38                    sec   
0136 40D7              *** end of 21-Apr-91 DAL
0137 40D7 F7 41                 sbc   [<data],y                Less height of icon.
0138 40D9 90 3E                 bcc   dontFit
0139 40DB 4A                    lsr   a                        Half way.
0140 40DC 18                    clc   
0141 40DD 65 15                 adc   <rect+y1                 Starting position.
0142 40DF A8                    tay                            Pass starting Y position.
0143 40E0 A6 17                 ldx   <rect+x1
0144 40E2 20 1A 44              jsr   set_penpos               Set pen position.
0145 40E5              ;
0146 40E5 48                    pha                            Space for result.
0147 40E6 A2 04 99 22           _GetFontFlags                  Save state.
0148 40ED 48                    pha                            Space for result.
0149 40EE A2 04 9D 22           _GetTextMode                   Save state.
0150 40F5              ;
0151 40F5 A9 02 00              lda   #simpNorBack             Icon color index.
0152 40F8 20 E4 3C              jsr   set_textmode             Set icon color and OR mode.
0153 40FB              ;
0154 40FB A9 10 44              lda   #drawChar                Address of function to perform while
0155 40FE 20 91 37              jsr   doIconFunc               icon font is current.
0156 4101              ;
0157 4101 A2 04 9C 22           _SetTextMode                   Restore original text mode.
0158 4108 A2 04 98 22           _SetFontFlags                  Restore original text flags.
0159 410F
0160 410F 60                    rts   
0161 4110
0162 4110
0163 4110 D4 2D        drawChar pei   <work                    Pass character (icon number) to print.
0164 4112 A2 04 A4 22           _DrawChar 
0165 4119
0166 4119 60           dontFit  rts   
0167 411A
0168 411A                       ENDP 
0169 411A
0170 411A
0171 411A              ;====================================================================
0172 411A              ;
0173 411A              ;        Move pen to a given point without drawing.
0174 411A              ;
0175 411A              ;   IN:    y = y coordinate.
0176 411A              ;          x = x coordinate.
0177 411A              ;
0178 411A              ;====================================================================
0179 411A              set_penpos proc EXPORT 
0180 411A
0181 411A DA                    phx   
0182 411B 5A                    phy   
0183 411C A2 04 3A 22           _MoveTo 
0184 4123
0185 4123 60                    rts   
0186 4124
0187 4124                       ENDP 
0188 4124
0189 4124
0190 4124                       title 'SCROLL_PROC' 
0191 4124              ;====================================================================
0192 4124              ;
0193 4124              ;          Main line Scroll Bar handler.
0194 4124              ;
0195 4124              ;   IN:    a = task.
0196 4124              ;          Ctlptr = pointer to control.
0197 4124              ;          param = additional parameter.
0198 4124              ;
0199 4124              ;  OUT:    a = low word of returned value.
0200 4124              ;          x = high word of returned value.
0201 4124              ;
0202 4124              ;====================================================================
0203 4124              scroll_proc  proc EXPORT 
0204 4124 C9 14 00              cmp   #ctlWinStateChange+1
0205 4127 90 03                 bcc   @1
0206 4129 82 74 FF              brl   null_ret
0207 412C              @1        
0208 412C
0209 412C 0A                    asl   a                        Compute index for dispatch.
0210 412D AA                    tax   
0211 412E 7C 31 44              jmp   (scroll_task_list,x)     Complete the task.
0212 4131              ;
0213 4131              ;
0214 4131                       export scroll_task_list 
0215 4131 50 46        scroll_task_list DC W:scroll_draw       0 Draw.
0216 4133 A0 43                 DC W:null_ret                  1 Compute drag RECT.
0217 4135 D0 45                 DC W:scroll_hit                2 Common hit test routine.
0218 4137 6B 44                 DC W:scroll_init               3 Initialize the control.
0219 4139 A0 43                 DC W:null_ret                  4 Dispose.
0220 413B A0 43                 DC W:null_ret                  5 Called after drag is completed.
0221 413D A0 43                 DC W:null_ret                  6 Setup for dragging.
0222 413F A0 43                 DC W:null_ret                  7 Perform dragging.
0223 4141 A0 43                 DC W:null_ret                  8 Auto track.
0224 4143 B6 48                 DC W:move_thumb                9 New value.
0225 4145 49 48                 DC W:newView                   10 Called with new Min and Max values.
0226 4147 F8 49                 DC W:move_bar                  11 Move scroll bar.
0227 4149 59 44                 DC W:rec_size                  12 Return size of scroll bar record.
0228 414B A0 43                 DC W:null_ret                  13 ctlhandleEvent
0229 414D A0 43                 DC W:null_ret                  14 ctlChangeTarget
0230 414F A0 43                 DC W:null_ret                  15 ctlChagneBounds
0231 4151 A0 43                 DC W:null_ret                  16 ctlWindChagneSize
0232 4153 A0 43                 DC W:null_ret                  17 ctlHandleTab
0233 4155 A0 43                 DC W:null_ret                  18 ctlNotifyMultiPart
0234 4157 A5 43                 DC W:Inval_rect                19 ctlWinStateChange (just inval)
0235 4159
0236 4159                       ENDP 
0237 4159
0238 4159                       title 'SCROLL_PROC -- rec_size' 
0239 4159              ;====================================================================
0240 4159              ;
0241 4159              ;          Return size of required record.
0242 4159              ;
0243 4159              ;====================================================================
0244 4159              rec_size proc EXPORT 
0245 4159
0246 4159 A5 29                 lda   param
0247 415B 05 2B                 ora   param+2
0248 415D F0 05                 beq   OldSize
0249 415F
0250 415F A9 40 00              lda   #SuperCtlSize
0251 4162 80 03                 bra   ReturnIt
0252 4164
0253 4164              OldSize   
0254 4164
0255 4164 A9 38 00              lda   #PageRegion+8            Size of scroll bar record.
0256 4167
0257 4167              ReturnIt  
0258 4167 A2 00 00              ldx   #0                       High word of size.
0259 416A
0260 416A 60                    rts   
0261 416B
0262 416B                       ENDP 
0263 416B
0264 416B
0265 416B                       title 'SCROLL_PROC -- scroll_init' 
0266 416B              ;====================================================================
0267 416B              ;
0268 416B              ;          Initialize scroll bar.
0269 416B              ;
0270 416B              ; Change History
0271 416B              ;
0272 416B              ; 24 Jul 88         Steven Glass
0273 416B              ;
0274 416B              ; Added control value validation.
0275 416B              ;
0276 416B              ;
0277 416B              ; 10 Oct 88         Steven Glass
0278 416B              ;
0279 416B              ; Added code to translate NewCtl2 inputs to NewCtl inputs.
0280 416B              ;
0281 416B              ; 07 Dec 88         STeven Glass & Mensch
0282 416B              ;
0283 416B              ; Fixed bug with color table ref's and control templates.  The
0284 416B              ; code bne'd when it should have beq'd for pCount of 9.
0285 416B              ;
0286 416B              ;====================================================================
0287 416B              scroll_init proc EXPORT 
0288 416B
0289 416B              *** added 9-Jan-92 DAL -- set valid port
0290 416B 48                    pha   
0291 416C 48                    pha   
0292 416D A2 04 1C 22           _GetPort 
0293 4174 48                    pha   
0294 4175 48                    pha   
0295 4176 A2 0E 20 22           _GetWMgrPort 
0296 417D A2 04 1B 22           _SetPort 
0297 4184              *** end 9-Jan-92
0298 4184              *** added 9-Dec-91 DAL -- check for new color table
0299 4184 A2 10 12 22           _CtlNewRes 
0300 418B              *** end 9-Dec-91
0301 418B A2 04 1B 22           _SetPort                       ;9-Jan-92 DAL
0302 4192
0303 4192 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
0304 4195 B7 05                 lda   [ctlPtr],y
0305 4197 10 37                 bpl   OldWay
0306 4199
0307 4199              ;-----------------------------------------------------------
0308 4199              ;
0309 4199              ; This is being called from NewControl2.  This means that
0310 4199              ; Param holds pointer to the template.  CtlColor is not set
0311 4199              ; up.  DataSize and ViewSize are not in Param.
0312 4199              ;
0313 4199              ; We fiddle with the data as follows:
0314 4199              ;    Copy the intital thumb value from template to record.
0315 4199              ;    Check the pcount to see if there is a color table
0316 4199              ;    If YES, copy ref to CtlColor
0317 4199              ;    Copy DataSize and ViewSize to Param
0318 4199              ;    Fall into old code.
0319 4199              ;
0320 4199
0321 4199 A0 1E 00              ldy   #ScrollTemplate.InitialThumb
0322 419C B7 29                 lda   [param],y
0323 419E A0 12 00              ldy   #NewCtlRecord.ctlValue
0324 41A1 97 05                 sta   [ctlPtr],y
0325 41A3
0326 41A3 A0 00 00              ldy   #ScrollTemplate.pcount   is there a color table
0327 41A6 B7 29                 lda   [param],y
0328 41A8 C9 09 00              cmp   #9
0329 41AB F0 14                 beq   NoColorTable
0330 41AD
0331 41AD A0 20 00              ldy   #ScrollTemplate.ColorRef yes, put its ref in.
0332 41B0 B7 29                 lda   [param],y
0333 41B2 AA                    tax   
0334 41B3 C8                    iny   
0335 41B4 C8                    iny   
0336 41B5 B7 29                 lda   [param],y
0337 41B7 A0 26 00              ldy   #NewCtlRecord.CtlColor+2
0338 41BA 97 05                 sta   [ctlPtr],y
0339 41BC 88                    dey   
0340 41BD 88                    dey   
0341 41BE 8A                    txa   
0342 41BF 97 05                 sta   [ctlPtr],y
0343 41C1
0344 41C1              NoColorTable                            ;finished with color table
0345 41C1
0346 41C1 A0 1A 00              ldy   #ScrollTemplate.DataSize ;fix param and fall into old way
0347 41C4 B7 29                 lda   [param],y
0348 41C6 AA                    tax   
0349 41C7 A0 1C 00              ldy   #ScrollTemplate.ViewSize
0350 41CA B7 29                 lda   [param],y
0351 41CC 85 29                 sta   param
0352 41CE 86 2B                 stx   param+2
0353 41D0
0354 41D0
0355 41D0              OldWay    
0356 41D0              ;
0357 41D0              ; --- Validate the maximum value ------
0358 41D0              ;
0359 41D0 A5 2B                 lda   param+2                  ; Max allowable value is Max-View
0360 41D2 38                    sec   
0361 41D3 E5 29                 sbc   param
0362 41D5 A0 12 00              ldy   #Ctlvalue                ; compare to the current value
0363 41D8 D7 05                 cmp   [<Ctlptr],y              ; from control record
0364 41DA B0 07                 bcs   @MaxOK                   ; ok
0365 41DC B7 05                 lda   [<Ctlptr],y              ; Bump max so it is equal to value+view
0366 41DE 18                    clc   
0367 41DF 65 29                 adc   <param
0368 41E1 85 2B                 sta   <param+2                 ; adjust the max value.
0369 41E3 C5 29        @MaxOK   cmp   <param                   ; is it greater than the min value?
0370 41E5              ;
0371 41E5              ; --- Set view and data size -----------------------
0372 41E5              ;
0373 41E5 A0 1C 00              ldy   #Ctldata
0374 41E8 A5 29                 lda   <param
0375 41EA 97 05                 sta   [<Ctlptr],y
0376 41EC C8                    iny   
0377 41ED C8                    iny   
0378 41EE A5 2B                 lda   <param+2
0379 41F0 97 05                 sta   [<Ctlptr],y
0380 41F2              ;
0381 41F2              ;
0382 41F2              ; --- Set default color table pointer --------------
0383 41F2              ;
0384 41F2 A0 25 00              ldy   #CtlColor+1
0385 41F5 B7 05                 lda   [<Ctlptr],y
0386 41F7 88                    dey   
0387 41F8 17 05                 ora   [<Ctlptr],y
0388 41FA D0 0C                 bne   skip1
0389 41FC              ;
0390 41FC A9 A0 38              lda   #scroll_color
0391 41FF 97 05                 sta   [<Ctlptr],y
0392 4201 C8                    iny   
0393 4202 C8                    iny   
0394 4203 A9 02 00              lda   #scroll_color>>16
0395 4206 97 05                 sta   [<Ctlptr],y
0396 4208              ;
0397 4208              ;
0398 4208              ; --- Set sizes --------------------------------------------
0399 4208              ;
0400 4208 20 25 38     skip1    jsr   CMsetrect                Put enclosing RECT into 'rect'.
0401 420B              ;
0402 420B A2 52 00              ldx   #uArrowH                 Use up arrow for vertical bar,
0403 420E A0 10 00              ldy   #CtlFlag
0404 4211 B7 05                 lda   [<Ctlptr],y
0405 4213 29 10 00              and   #DIR_SCROLL
0406 4216 F0 03                 beq   ok1
0407 4218 A2 5A 00              ldx   #lArrowH                 and left arrow for horizontal bars.
0408 421B 9B           ok1      txy   
0409 421C B7 41                 lda   [<data],y                Height of arrow icon,
0410 421E 18                    clc   
0411 421F 69 03 00              adc   #3                       plus leading,
0412 4222 A0 21 00              ldy   #rect2+y2
0413 4225 97 41                 sta   [<data],y                equals total size.
0414 4227              ;
0415 4227 9B                    txy   
0416 4228 C8                    iny                            Width of arrow icon,
0417 4229 C8                    iny   
0418 422A B7 41                 lda   [<data],y
0419 422C 18                    clc   
0420 422D 69 08 00              adc   #8                       plus leading,
0421 4230 A0 23 00              ldy   #rect2+x2
0422 4233 97 41                 sta   [<data],y                equals total size.
0423 4235              ;
0424 4235              ;
0425 4235              ; ------ Set default height --------------------------------------
0426 4235              ;
0427 4235 A5 19                 lda   <rect+y2                 Is it set?
0428 4237 D0 0F                 bne   skip2
0429 4239              ;
0430 4239 A5 15                 lda   <rect+y1
0431 423B 18                    clc   
0432 423C A0 21 00              ldy   #rect2+y2
0433 423F 77 41                 adc   [<data],y
0434 4241 85 19                 sta   <rect+y2
0435 4243 A0 0C 00              ldy   #CtlRect+y2
0436 4246 97 05                 sta   [<Ctlptr],y              Set height of enclosing RECT.
0437 4248              ;
0438 4248 A5 1B        skip2    lda   <rect+x2                 Is it set?
0439 424A D0 0F                 bne   skip3
0440 424C              ;
0441 424C A5 17                 lda   <rect+x1
0442 424E 18                    clc   
0443 424F A0 23 00              ldy   #rect2+x2
0444 4252 77 41                 adc   [<data],y
0445 4254 85 1B                 sta   <rect+x2
0446 4256 A0 0E 00              ldy   #CtlRect+x2
0447 4259 97 05                 sta   [<Ctlptr],y              Set width of enclosing RECT.
0448 425B              ;
0449 425B              ;
0450 425B              ; ------ Set page region, by subtracting arrows from enclosing RECT ------
0451 425B              ;
0452 425B A0 10 00     skip3    ldy   #CtlFlag
0453 425E B7 05                 lda   [<Ctlptr],y
0454 4260 48                    pha   
0455 4261 29 01 00              and   #UP_FLAG
0456 4264 F0 0A                 beq   skip10
0457 4266              ;
0458 4266 A5 15                 lda   <rect+y1
0459 4268 18                    clc   
0460 4269 A0 21 00              ldy   #rect2+y2                Add height of icon plus leading.
0461 426C 77 41                 adc   [<data],y
0462 426E 85 15                 sta   <rect+y1
0463 4270              ;
0464 4270 A3 01        skip10   lda   1,s
0465 4272 29 02 00              and   #DOWN_FLAG
0466 4275 F0 0A                 beq   skip11
0467 4277              ;
0468 4277 A5 19                 lda   <rect+y2
0469 4279 38                    sec   
0470 427A A0 21 00              ldy   #rect2+y2
0471 427D F7 41                 sbc   [<data],y
0472 427F 85 19                 sta   <rect+y2
0473 4281              ;
0474 4281 A3 01        skip11   lda   1,s
0475 4283 29 04 00              and   #LEFT_FLAG
0476 4286 F0 0A                 beq   skip12
0477 4288              ;
0478 4288 A5 17                 lda   <rect+x1
0479 428A 18                    clc   
0480 428B A0 23 00              ldy   #rect2+x2
0481 428E 77 41                 adc   [<data],y
0482 4290 85 17                 sta   <rect+x1
0483 4292              ;
0484 4292 68           skip12   pla   
0485 4293 29 08 00              and   #RIGHT_FLAG
0486 4296 F0 0A                 beq   skip13
0487 4298              ;
0488 4298 A5 1B                 lda   <rect+x2
0489 429A 38                    sec   
0490 429B A0 23 00              ldy   #rect2+x2
0491 429E F7 41                 sbc   [<data],y
0492 42A0 85 1B                 sta   <rect+x2
0493 42A2              ;
0494 42A2 A0 36 00     skip13   ldy   #PageRegion+x2           Initialize page region.
0495 42A5 20 C4 45              jsr   to_Ctl                   Move 'rect' into page region.
0496 42A8              ;
0497 42A8 20 F2 36              jsr   pushrect                 Indent thumber from page region.
0498 42AB 20 E4 36              jsr   pushVvert_pen
0499 42AE F4 01 00              pea   1
0500 42B1 A2 04 4C 22           _InsetRect 
0501 42B8              ;
0502 42B8 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0503 42BB A0 2E 00              ldy   #Thumb+x2
0504 42BE 20 C4 45              jsr   to_Ctl                   Move 'rect' into thumber RECT.
0505 42C1              ;
0506 42C1              ;
0507 42C1              ; --- Set thumber position ---------------------------
0508 42C1              ;
0509 42C1 82 88 03              brl   new_thumb
0510 42C4
0511 42C4
0512 42C4
0513 42C4
0514 42C4              ;====================================================================
0515 42C4              ;
0516 42C4              ;          Move 'rect' into control RECT.
0517 42C4              ;
0518 42C4              ;  IN:     y = offset into record plus x2.
0519 42C4              ;
0520 42C4              ;====================================================================
0521 42C4              to_Ctl    
0522 42C4 A2 06 00              ldx   #x2
0523 42C7 B5 15        lop1     lda   <rect,x
0524 42C9 97 05                 sta   [<Ctlptr],y
0525 42CB 88                    dey                            Anything for some bytes.
0526 42CC CA                    dex   
0527 42CD 10 F8                 bpl   lop1
0528 42CF
0529 42CF 60                    rts   
0530 42D0
0531 42D0
0532 42D0                       ENDP 
0533 42D0
0534 42D0
0535 42D0
0536 42D0
0537 42D0                       title 'SCROLL_PROC -- scroll_hit' 
0538 42D0              ;====================================================================
0539 42D0              ;
0540 42D0              ;          Check hit on scroll bar.
0541 42D0              ;
0542 42D0              ;   IN:    Ctlptr = pointer to scroll bar record.
0543 42D0              ;          param = y coordinate to check.
0544 42D0              ;          param+2 = x coordinate to check.
0545 42D0              ;
0546 42D0              ;  OUT:    a = 0 if no hit.
0547 42D0              ;              5 if on up arrow.
0548 42D0              ;              6 if on down arrow.
0549 42D0              ;              7 if on page up region.
0550 42D0              ;              8 if on page down region.
0551 42D0              ;            129 if on thumber.
0552 42D0              ;
0553 42D0              ;====================================================================
0554 42D0              scroll_hit proc EXPORT 
0555 42D0
0556 42D0 A0 1C 00              ldy   #CtlData
0557 42D3 B7 05                 lda   [<Ctlptr],y              Total view.
0558 42D5 C8                    iny   
0559 42D6 C8                    iny   
0560 42D7 D7 05                 cmp   [<Ctlptr],y              Total data area.
0561 42D9 90 04                 bcc   ok1
0562 42DB              ;
0563 42DB A9 00 00              lda   #0                       No hit anywhere if maxed out.
0564 42DE
0565 42DE 60                    rts   
0566 42DF
0567 42DF A0 30 00     ok1      ldy   #PageRegion              Check page region.
0568 42E2 20 39 46              jsr   check_pt
0569 42E5 F0 31                 beq   next1
0570 42E7
0571 42E7 A0 28 00              ldy   #Thumb                   Check thumber.
0572 42EA 20 39 46              jsr   check_pt
0573 42ED A2 81 00              ldx   #THUMB_PART              Part code, just in case.
0574 42F0 A8                    tay                            Was it a hit?
0575 42F1 D0 44                 bne   got_it
0576 42F3              ;
0577 42F3              ; --- Must be in page region, up or down? -----------------
0578 42F3              ;
0579 42F3 A2 07 00              ldx   #UPP_PART                Page up part code.
0580 42F6 A0 10 00              ldy   #CtlFlag
0581 42F9 B7 05                 lda   [<Ctlptr],y
0582 42FB 29 10 00              and   #DIR_SCROLL              Vertical or horizontal bar?
0583 42FE D0 0C                 bne   horizontal
0584 4300              ;
0585 4300 A5 29                 lda   <param                   Get y coordinate.
0586 4302 A0 28 00              ldy   #Thumb+y1
0587 4305 D7 05                 cmp   [<Ctlptr],y
0588 4307 90 2E                 bcc   got_it
0589 4309 E8                    inx                            Page down part code.
0590 430A 80 2B                 bra   got_it                   Must be page down.
0591 430C              ;
0592 430C              ;
0593 430C A5 2B        horizontal lda   <param+2               Get x coordinate.
0594 430E A0 2A 00              ldy   #Thumb+x1
0595 4311 D7 05                 cmp   [<Ctlptr],y
0596 4313 90 22                 bcc   got_it
0597 4315 E8                    inx                            Page down part code.
0598 4316 80 1F                 bra   got_it                   Must be page down.
0599 4318              ;
0600 4318              ;
0601 4318              ; --- Must be in an arrow box ------------------------------
0602 4318              ;
0603 4318 A2 05 00     next1    ldx   #UP_PART
0604 431B              ;
0605 431B A0 30 00              ldy   #PageRegion+y1
0606 431E A5 29                 lda   <param                   Get y coordinate.
0607 4320 D7 05                 cmp   [<Ctlptr],y
0608 4322 90 13                 bcc   got_it
0609 4324              ;
0610 4324 E8                    inx                            Down arrow part code.
0611 4325              ;
0612 4325 A0 34 00              ldy   #PageRegion+y2
0613 4328 D7 05                 cmp   [<Ctlptr],y
0614 432A B0 0B                 bcs   got_it
0615 432C              ;
0616 432C CA                    dex                            Back to up arrow.
0617 432D              ;
0618 432D A0 32 00              ldy   #PageRegion+x1
0619 4330 A5 2B                 lda   <param+2                 Get x coordinate.
0620 4332 D7 05                 cmp   [<Ctlptr],y
0621 4334 90 01                 bcc   got_it
0622 4336
0623 4336 E8                    inx                            Down arrow part code.
0624 4337
0625 4337 8A           got_it   txa   
0626 4338
0627 4338 60                    rts   
0628 4339              ;
0629 4339              ;
0630 4339              ;   IN:    y = offset into record to check + x2.
0631 4339              ;
0632 4339                       EXPORT check_pt 
0633 4339              check_pt                                ;
0634 4339              ;
0635 4339 48                    pha                            Space for result.
0636 433A A9 29 00              lda   #param
0637 433D 20 F5 36              jsr   pushzpage                Pass pointer of point to check.
0638 4340 98                    tya   
0639 4341 20 D7 3C              jsr   pushrecord               Pass pointer of RECT to check.
0640 4344 A2 04 4F 22           _PtInRect 
0641 434B 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0642 434E 68                    pla   
0643 434F 60                    rts   
0644 4350              ;
0645 4350                       ENDP 
0646 4350
0647 4350
0648 4350                       title 'SCROLL_PROC -- scroll_draw' 
0649 4350              ;====================================================================
0650 4350              ;
0651 4350              ;          Draw a scroll bar.
0652 4350              ;
0653 4350              ;   IN:    Ctlptr = control pointer.
0654 4350              ;          param = part to draw.
0655 4350              ;
0656 4350              ;====================================================================
0657 4350              scroll_draw proc EXPORT 
0658 4350
0659 4350 20 32 4A              jsr   CheckForVis              If not vis, don't come back.
0660 4353
0661 4353              *** added 9-Dec-91 DAL -- if we're part of an extended list, force focus frame update
0662 4353 A0 10 00              ldy   #NewCtlRecord.ctlFlag
0663 4356 B7 05                 lda   [<ctlPtr],y
0664 4358 29 40 00              and   #$0040                   ;partOfExtendedList
0665 435B F0 2B                 beq   @notExtended
0666 435D
0667 435D              *** added 6-Feb-92 DAL -- Preserve State around this CallCtlDefProc
0668 435D A0 50 00              ldy   #state
0669 4360 B7 41                 lda   [<data],y
0670 4362 48                    pha   
0671 4363              *** end 6-Feb-92
0672 4363
0673 4363 48                    pha   
0674 4364 48                    pha                            ;space for CallCtlDefProc result
0675 4365 A0 22 00              ldy   #NewCtlRecord.ctlRefCon+2
0676 4368 B7 05                 lda   [<ctlPtr],y
0677 436A 48                    pha   
0678 436B 88                    dey   
0679 436C 88                    dey   
0680 436D B7 05                 lda   [<ctlPtr],y
0681 436F 48                    pha                            ;push List handle (from scroll refcon)
0682 4370 F4 0E 00              pea   ctlChangeActivity
0683 4373 F4 00 00              pea   0
0684 4376 F4 00 00              pea   0                        ;reserved
0685 4379 A2 10 2C 22           _CallCtlDefProc 
0686 4380 68                    pla   
0687 4381 68                    pla                            ;discard result
0688 4382
0689 4382              *** added 6-Feb-92 DAL -- Restore State so arrows will hilite properly
0690 4382 68                    pla   
0691 4383 A0 50 00              ldy   #state
0692 4386 97 41                 sta   [<data],y
0693 4388              *** end 6-Feb-92
0694 4388
0695 4388              @notExtended  
0696 4388              *** end 9-Dec-91 DAL
0697 4388
0698 4388 20 42 4A              jsr   SetupColor
0699 438B
0700 438B A5 29                 lda   <param                   Get part code.
0701 438D 29 7F 00              and   #$7F
0702 4390 0A                    asl   a
0703 4391 AA                    tax   
0704 4392 7C 95 46              jmp   (part_list,x)
0705 4395              ;
0706 4395              ;
0707 4395 A7 46        part_list DC W:draw_all                 0 Draw entire control.
0708 4397 9C 47                 DC W:draw_thumb                1 Draw thumber.
0709 4399 00 00                 DC W:0                         2
0710 439B 00 00                 DC W:0                         3
0711 439D 00 00                 DC W:0                         4
0712 439F 16 47                 DC W:draw_up1                  5 Draw up arrow.
0713 43A1 2C 47                 DC W:draw_down1                6 Draw down arrow.
0714 43A3 A0 43                 DC W:null_ret                  7 Draw page region.
0715 43A5 A0 43                 DC W:null_ret                  8 Draw page region.
0716 43A7              ;
0717 43A7              ;
0718 43A7              ;= = = = = = = = = = = = = = = = = = = = = = = = =
0719 43A7              ;          Draw entire scroll bar.
0720 43A7              ;= = = = = = = = = = = = = = = = = = = = = = = = =
0721 43A7              ;
0722 43A7 A0 4E 00     draw_all ldy   #active
0723 43AA B7 41                 lda   [<data],y                Is control inactive?
0724 43AC 10 11                 bpl   skip100
0725 43AE              ;
0726 43AE              ; --- Draw an inactive scroll bar --------------------------
0727 43AE              ;
0728 43AE A0 0E 00              ldy   #InactiveColor           Inactive color.
0729 43B1 B7 11                 lda   [<colorPtr],y
0730 43B3 29 F0 00              and   #$00F0
0731 43B6 A8                    tay                            Pass interior color.
0732 43B7 A7 11                 lda   [<colorPtr]              Pass frame color.
0733 43B9 29 F0 00              and   #$00F0
0734 43BC 82 50 F0              brl   drawrect                 Draw and exit.
0735 43BF              ;
0736 43BF              ;
0737 43BF              ; --- Draw an active scroll bar -----------------------------
0738 43BF              ;
0739 43BF 20 F1 46     skip100  jsr   inner_scroll             Draw interior of scroll bar.
0740 43C2              ;
0741 43C2 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0742 43C5 A0 10 00              ldy   #CtlFlag
0743 43C8 B7 05                 lda   [<Ctlptr],y
0744 43CA 48                    pha   
0745 43CB 29 01 00              and   #UP_FLAG                 Up arrow?
0746 43CE F0 03                 beq   next100
0747 43D0              ;
0748 43D0 20 23 47              jsr   draw_up2                 Draw up arrow.
0749 43D3              ;
0750 43D3 A3 01        next100  lda   1,s
0751 43D5 29 02 00              and   #DOWN_FLAG               Down arrow?
0752 43D8 F0 03                 beq   next101
0753 43DA              ;
0754 43DA 20 39 47              jsr   draw_down2               Draw down arrow.
0755 43DD              ;
0756 43DD A3 01        next101  lda   1,s
0757 43DF 29 04 00              and   #LEFT_FLAG               Left arrow?
0758 43E2 F0 03                 beq   next102
0759 43E4              ;
0760 43E4 20 42 47              jsr   draw_left2               Draw left arrow.
0761 43E7              ;
0762 43E7 68           next102  pla   
0763 43E8 29 08 00              and   #RIGHT_FLAG              Right arrow?
0764 43EB F0 03                 beq   exit100
0765 43ED              ;
0766 43ED 82 5B 00              brl   draw_right2              Draw right arrow.
0767 43F0              ;
0768 43F0 60           exit100  rts   
0769 43F1              ;
0770 43F1              ;
0771 43F1                       EXPORT inner_scroll 
0772 43F1              inner_scroll                            ;
0773 43F1              ;
0774 43F1 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0775 43F4 A0 1C 00              ldy   #CtlData
0776 43F7 B7 05                 lda   [<Ctlptr],y              Total view.
0777 43F9 C8                    iny   
0778 43FA C8                    iny   
0779 43FB D7 05                 cmp   [<Ctlptr],y              Total data area.
0780 43FD 90 0E                 bcc   ok100                    Everything in view?
0781 43FF              ;
0782 43FF A0 4E 00              ldy   #active                  Set active flag for arrows.
0783 4402 A9 FF FF              lda   #$FFFF
0784 4405 97 41                 sta   [<data],y
0785 4407              ;
0786 4407 A0 08 00              ldy   #ThumbNorColor           Use thumber's color to draw page region.
0787 440A 82 47 00              brl   draw_page
0788 440D              ;
0789 440D A0 0C 00     ok100    ldy   #PageRgnColor            Page region's color and pattern.
0790 4410 20 54 47              jsr   draw_page                Draw page region.
0791 4413              ;
0792 4413 82 86 00              brl   draw_thumb               Draw thumber.
0793 4416              ;
0794 4416              ;
0795 4416              ;
0796 4416              ;= = = = = = = = = = = = = = = = =
0797 4416              ;          Draw up arrow.
0798 4416              ;= = = = = = = = = = = = = = = = =
0799 4416              ;
0800 4416 20 02 37     draw_up1 jsr   dereference              Ctlptr = (Ctlhand).
0801 4419 A0 10 00              ldy   #CtlFlag                 Vertical or horizontal?
0802 441C B7 05                 lda   [<Ctlptr],y
0803 441E 29 10 00              and   #DIR_SCROLL
0804 4421 D0 1F                 bne   draw_left2
0805 4423              ;
0806 4423 20 B6 47     draw_up2 jsr   up_box                   Draw up arrow box.
0807 4426              ;
0808 4426 A2 08 00              ldx   #UP_ARROW                Up arrow pattern index.
0809 4429 82 E3 00              brl   draw_arrow2
0810 442C              ;
0811 442C              ;
0812 442C              ;= = = = = = = = = = = = = = = = = = =
0813 442C              ;          Draw down arrow.
0814 442C              ;= = = = = = = = = = = = = = = = = = =
0815 442C              ;
0816 442C 20 02 37     draw_down1 jsr   dereference            Ctlptr = (Ctlhand).
0817 442F A0 10 00              ldy   #CtlFlag                 Vertical or horizontal?
0818 4432 B7 05                 lda   [<Ctlptr],y
0819 4434 29 10 00              and   #DIR_SCROLL
0820 4437 D0 12                 bne   draw_right2
0821 4439              ;
0822 4439 20 C6 47     draw_down2 jsr   down_box               Draw down arrow box.
0823 443C              ;
0824 443C A2 0A 00              ldx   #DOWN_ARROW              Down arrow pattern index.
0825 443F 82 CD 00              brl   draw_arrow2
0826 4442              ;
0827 4442              ;            
0828 4442              ;= = = = = = = = = = = = = = = = = =
0829 4442              ;          Draw left arrow.
0830 4442              ;= = = = = = = = = = = = = = = = = =
0831 4442              ;
0832 4442 20 D6 47     draw_left2 jsr   left_box               Draw left arrow box.
0833 4445              ;
0834 4445 A2 0C 00              ldx   #LEFT_ARROW              Left arrow pattern index.
0835 4448 82 C4 00              brl   draw_arrow2
0836 444B              ;
0837 444B              ;            
0838 444B              ;= = = = = = = = = = = = = = = = = = =
0839 444B              ;          Draw right arrow.
0840 444B              ;= = = = = = = = = = = = = = = = = = =
0841 444B              ;
0842 444B 20 E6 47     draw_right2 jsr   right_box             Draw right arrow box.
0843 444E              ;
0844 444E A2 0E 00              ldx   #RITE_ARROW              Right arrow pattern index.
0845 4451 82 BB 00              brl   draw_arrow2
0846 4454              ;
0847 4454              ;
0848 4454              ;= = = = = = = = = = = = = = = = = =
0849 4454              ;          Draw page region.
0850 4454              ;= = = = = = = = = = = = = = = = = =
0851 4454              ;         
0852 4454 5A           draw_page phy   Save color to use.
0853 4455              ;
0854 4455 A7 11                 lda   [<colorptr]              Get outline color.
0855 4457 A8                    tay   
0856 4458 20 21 3E              jsr   set_patt
0857 445B DA                    phx   
0858 445C 5A                    phy   
0859 445D A2 04 30 22           _SetPenPat 
0860 4464              ;
0861 4464 A0 36 00              ldy   #PageRegion+x2
0862 4467 20 28 38              jsr   CMsetrect2               Set 'rect' to page region.
0863 446A 7A                    ply   
0864 446B              ;
0865 446B 20 F2 36              jsr   pushrect                 For FillRect call.
0866 446E 5A                    phy                            Pass color.
0867 446F              ;
0868 446F 20 F2 36              jsr   pushrect                 Pass address of RECT to frame.
0869 4472 A2 04 53 22           _FrameRect 
0870 4479              ;
0871 4479              ;
0872 4479 20 F2 36              jsr   pushrect
0873 447C 20 E4 36              jsr   pushVvert_pen
0874 447F F4 01 00              pea   1
0875 4482 A2 04 4C 22           _InsetRect 
0876 4489              ;
0877 4489 7A                    ply                            Color index to use.
0878 448A B7 11                 lda   [<colorptr],y
0879 448C A8                    tay   
0880 448D 20 21 3E              jsr   set_patt
0881 4490 DA                    phx   
0882 4491 5A                    phy   
0883 4492 A2 04 57 22           _FillRect 
0884 4499              ;
0885 4499 82 66 EF              brl   dereference
0886 449C              ;
0887 449C              ;
0888 449C              ;= = = = = = = = = = = = = = = = = = = = = = = = =
0889 449C              ;          Draw scroll bar thumb.
0890 449C              ;= = = = = = = = = = = = = = = = = = = = = = = = =
0891 449C              ;
0892 449C                       EXPORT draw_thumb 
0893 449C              draw_thumb                              ;
0894 449C              ;
0895 449C A0 2E 00              ldy   #Thumb+x2
0896 449F 20 28 38              jsr   CMsetrect2               Put thumber coordinates into 'rect'.
0897 44A2              ;
0898 44A2 A0 08 00              ldy   #ThumbNorColor           Index to color of thumb.
0899 44A5 B7 11                 lda   [<colorPtr],y
0900 44A7 29 F0 00              and   #$00F0
0901 44AA A8                    tay                            Pass interior color.
0902 44AB A7 11                 lda   [<colorPtr]              Pass frame color.
0903 44AD 29 F0 00              and   #$00F0
0904 44B0 20 0F 37              jsr   drawrect
0905 44B3              ;
0906 44B3 82 4C EF              brl   dereference
0907 44B6
0908 44B6                       ENDP 
0909 44B6
0910 44B6
0911 44B6              ;====================================================================
0912 44B6              ;
0913 44B6              ;          Draw a up arrow box.
0914 44B6              ;
0915 44B6              ;====================================================================
0916 44B6              up_box   proc EXPORT 
0917 44B6
0918 44B6 20 25 38              jsr   CMsetrect                Put enclosing RECT into 'rect'.
0919 44B9              ;
0920 44B9 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0921 44BC A0 30 00              ldy   #PageRegion+y1
0922 44BF B7 05                 lda   [<Ctlptr],y
0923 44C1 1A                    inc   a
0924 44C2 85 19                 sta   <rect+y2
0925 44C4 80 2E                 bra   common
0926 44C6              ;
0927 44C6              ; = = = = = = = = = = = = = = = = = = = =
0928 44C6              ;          Draw a down arrow box.
0929 44C6              ; = = = = = = = = = = = = = = = = = = = =
0930 44C6              ;
0931 44C6                       EXPORT down_box 
0932 44C6              down_box                                ;
0933 44C6              ;
0934 44C6 20 25 38              jsr   CMsetrect                Put enclosing RECT into 'rect'.
0935 44C9              ;
0936 44C9 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0937 44CC A0 34 00              ldy   #PageRegion+y2
0938 44CF B7 05                 lda   [<Ctlptr],y
0939 44D1 3A                    dec   a
0940 44D2 85 15                 sta   <rect+y1
0941 44D4 80 1E                 bra   common
0942 44D6              ;
0943 44D6              ;
0944 44D6              ; = = = = = = = = = = = = = = = = = = = =
0945 44D6              ;          Draw a left arrow box.
0946 44D6              ; = = = = = = = = = = = = = = = = = = = =
0947 44D6              ;
0948 44D6                       EXPORT left_box 
0949 44D6              left_box                                ;
0950 44D6              ;
0951 44D6 20 25 38              jsr   CMsetrect                Put enclosing RECT into 'rect'.
0952 44D9              ;
0953 44D9 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0954 44DC A0 32 00              ldy   #PageRegion+x1
0955 44DF B7 05                 lda   [<Ctlptr],y
0956 44E1 1A                    inc   a
0957 44E2 85 1B                 sta   <rect+x2
0958 44E4 80 0E                 bra   common
0959 44E6              ;
0960 44E6              ;
0961 44E6              ; = = = = = = = = = = = = = = = = = = = =
0962 44E6              ;          Draw a right arrow box.
0963 44E6              ; = = = = = = = = = = = = = = = = = = = =
0964 44E6              ;
0965 44E6                       EXPORT right_box 
0966 44E6              right_box                               ;
0967 44E6              ;
0968 44E6 20 25 38              jsr   CMsetrect                Put enclosing RECT into 'rect'.
0969 44E9              ;
0970 44E9 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
0971 44EC A0 36 00              ldy   #PageRegion+x2
0972 44EF B7 05                 lda   [<Ctlptr],y
0973 44F1 3A                    dec   a
0974 44F2 85 17                 sta   <rect+x1
0975 44F4              ;
0976 44F4 A9 02 00     common   lda   #simpNorBack             Arrow box's interior color index.
0977 44F7 18                    clc   
0978 44F8 A0 50 00              ldy   #state
0979 44FB 77 41                 adc   [<data],y
0980 44FD A8                    tay   
0981 44FE B7 11                 lda   [<colorPtr],y
0982 4500 29 F0 00              and   #$00F0
0983 4503 A8                    tay                            Pass interior color.
0984 4504 A7 11                 lda   [<colorPtr]              Pass frame color.
0985 4506 29 F0 00              and   #$00F0
0986 4509 20 0F 37              jsr   drawrect                 Draw box.
0987 450C              ;
0988 450C 82 F3 EE              brl   dereference
0989 450F
0990 450F                       ENDP 
0991 450F
0992 450F
0993 450F                       title 'SCROLL_PROC -- utilities' 
0994 450F              ;====================================================================
0995 450F              ;
0996 450F              ;          Draw a scroll bar arrow.
0997 450F              ;
0998 450F              ;   IN:    state = 0 to draw normal, 2 to draw as selected.
0999 450F              ;          colorptr = pointer to color table.
1000 450F              ;          rect = enclosing RECT.
1001 450F              ;          x = icon number.
1002 450F              ;
1003 450F              ;  OUT:    rect = arrow's enclosing RECT.
1004 450F              ;
1005 450F              ;====================================================================
1006 450F              draw_arrow2 proc EXPORT 
1007 450F
1008 450F DA                    phx   
1009 4510              ;
1010 4510 BF 2E 38 02           lda   >arrowMap-UP_ARROW,x
1011 4514 A8                    tay   
1012 4515 B7 41                 lda   [<data],y                Get height of arrow.
1013 4517 BB                    tyx   
1014 4518 A0 21 00              ldy   #rect2+y2
1015 451B 97 41                 sta   [<data],y
1016 451D 9B                    txy   
1017 451E C8                    iny   
1018 451F C8                    iny   
1019 4520 B7 41                 lda   [<data],y                Get width of arrow.
1020 4522 A0 23 00              ldy   #rect2+x2
1021 4525 97 41                 sta   [<data],y
1022 4527              ;
1023 4527 FA                    plx   
1024 4528 20 34 48              jsr   center_hor               Center the arrow horizontally.
1025 452B 90 06                 bcc   exit                     Did the arrow fit in the box?
1026 452D              ;
1027 452D              ;                                       x = icon to print.
1028 452D 20 BC 43              jsr   print_icon               Print arrow icon.
1029 4530              ;
1030 4530 82 CF EE              brl   dereference
1031 4533              ;
1032 4533 60           exit     rts   
1033 4534
1034 4534                       ENDP 
1035 4534
1036 4534
1037 4534              ;====================================================================
1038 4534              ;
1039 4534              ;          Center an icon horizontally.
1040 4534              ;
1041 4534              ;   IN:    rect2+x2 = icon's width.
1042 4534              ;          rect = RECT to center in.
1043 4534              ;
1044 4534              ;  OUT:    Carry flag is clear if icon won't fit inside of 'rect'.
1045 4534              ;          rect+x1 = starting position of icon to be horizontally center.
1046 4534              ;          x = unchanged.
1047 4534              ;
1048 4534              ;====================================================================
1049 4534              center_hor proc EXPORT 
1050 4534
1051 4534 A5 1B                 lda   <rect+x2                 Get width of box.
1052 4536 38                    sec   
1053 4537 E5 17                 sbc   <rect+x1
1054 4539 38                    sec   
1055 453A A0 23 00              ldy   #rect2+x2                Less width of arrow.
1056 453D F7 41                 sbc   [<data],y
1057 453F 90 07                 bcc   exit                     Arrow won't fix in arrow box.
1058 4541 4A                    lsr   a                        Half way.
1059 4542 18                    clc   
1060 4543 65 17                 adc   <rect+x1
1061 4545 85 17                 sta   <rect+x1                 X point to draw arrow.
1062 4547              ;
1063 4547 38                    sec                            Set OK flag.
1064 4548 60           exit     rts   
1065 4549
1066 4549                       ENDP 
1067 4549
1068 4549
1069 4549              ;====================================================================
1070 4549              ;
1071 4549              ;        Set new Minimum and Maximum for scroll bar.
1072 4549              ;
1073 4549              ;   IN:    Ctlptr = pointer to scroll bar.
1074 4549              ;          param = new view, $FFFF to not set.
1075 4549              ;          param+2 = new data size, $FFFF to not set.
1076 4549              ;
1077 4549              ; Change History
1078 4549              ;
1079 4549              ; 24 Jul 88         Steven Glass
1080 4549              ;
1081 4549              ; If the view was not changed but the maximum value was changed,
1082 4549              ; the code was not going through the validation that it goes through
1083 4549              ; when the view is changed.  This allowed the max to be less than
1084 4549              ; the view.
1085 4549              ;
1086 4549              ; Added new label @skip2 which is now branched to when view is not
1087 4549              ; changed.  old code branched straight to redraw.
1088 4549              ;
1089 4549              ; Note that this code already tried to maintain a valid value, but
1090 4549              ; could fail to do so under certain circumstances.
1091 4549              ;
1092 4549              ;====================================================================
1093 4549              newView  proc EXPORT 
1094 4549
1095 4549              offset   equ   work                     Zero page usage.
1096 4549              height   equ   offset+2                 Height of page region.
1097 4549              front    equ   height+2
1098 4549              thumb_h  equ   front+2                  Height of thumber.
1099 4549              trect    equ   thumb_h+2
1100 4549
1101 4549
1102 4549 20 10 4A              jsr   scrollState
1103 454C 08                    php   
1104 454D
1105 454D 20 02 37              jsr   dereference              ;ctlPtr = (ctlHand).
1106 4550
1107 4550 A0 1E 00              ldy   #CtlData+2               ;set the parameters to the new view and
1108 4553 A5 2B                 lda   <param+2                 ;..data size for the scroll bar. The
1109 4555 C9 FF FF              cmp   #$FFFF                   ;..reason they weren't already is that
1110 4558 D0 02                 bne   @useParam2               ;..one of them could be $FFFF (no change)
1111 455A B7 05                 lda   [<ctlPtr],y
1112 455C 85 2B        @useParam2 sta   <param+2
1113 455E 88                    dey   
1114 455F 88                    dey   
1115 4560 A5 29                 lda   <param
1116 4562 C9 FF FF              cmp   #$FFFF
1117 4565 D0 02                 bne   @useParam
1118 4567 B7 05                 lda   [<ctlPtr],y
1119 4569 85 29        @useParam sta   <param
1120 456B
1121 456B A5 2B                 lda   <param+2
1122 456D 38                    sec   
1123 456E E5 29                 sbc   <param
1124 4570 B0 03                 bcs   @1
1125 4572 A9 00 00              lda   #0
1126 4575 A0 12 00     @1       ldy   #CtlValue                ;is the new maximum less than the current
1127 4578 D7 05                 cmp   [<ctlPtr],y              ;..value ? If not, then reset the value
1128 457A B0 04                 bcs   @valueOK                 ;..to the maximum value.
1129 457C 97 05                 sta   [<ctlPtr],y
1130 457E 80 13                 bra   @setAndDraw
1131 4580              @valueOK  
1132 4580 A0 1E 00              ldy   #CtlData+2
1133 4583 A5 2B                 lda   <param+2
1134 4585 D7 05                 cmp   [<ctlPtr],y
1135 4587 D0 0A                 bne   @setAndDraw
1136 4589 88                    dey   
1137 458A 88                    dey   
1138 458B A5 29                 lda   <param
1139 458D D7 05                 cmp   [<ctlPtr],y
1140 458F D0 02                 bne   @setAndDraw
1141 4591
1142 4591 28                    plp                            ;nothing changed, so just exit
1143 4592 60                    rts   
1144 4593
1145 4593 A0 1E 00     @setAndDraw ldy   #CtlData+2
1146 4596 A5 2B                 lda   <param+2
1147 4598 97 05                 sta   [<ctlPtr],y
1148 459A 88                    dey   
1149 459B 88                    dey   
1150 459C A5 29                 lda   <param
1151 459E 97 05                 sta   [<ctlPtr],y
1152 45A0
1153 45A0 20 4C 49              jsr   new_thumb
1154 45A3
1155 45A3 20 10 4A              jsr   scrollState              Is scroll bar drawable?
1156 45A6 90 05                 bcc   ok2
1157 45A8 28                    plp   
1158 45A9 90 01                 bcc   noexit
1159 45AB 60                    rts   
1160 45AC 08           noexit   php   
1161 45AD 28           ok2      plp   
1162 45AE 20 42 4A              jsr   SetupColor
1163 45B1 82 3D FE              brl   inner_scroll             Draw interior of scroll bar.
1164 45B4              ;
1165 45B4              ;
1166 45B4              ;
1167 45B4              ;====================================================================
1168 45B4              ;
1169 45B4              ;        Set new value for thumb
1170 45B4              ;
1171 45B4              ;   IN:    param has new value of thumb
1172 45B4              ;          param+2 has old value of thumb
1173 45B4              ;
1174 45B4              ; Change History
1175 45B4              ;
1176 45B4              ; 24 Jul 88         Steven Glass
1177 45B4              ;
1178 45B4              ; When the thumb value is changed we validate the existing 
1179 45B4              ; Max value.  If the thumb has a value that is greater than the
1180 45B4              ; MaxValue - ViewSize then something is wrong so we adjust MaxValue.
1181 45B4              ;
1182 45B4              ; The new MaxValue is set to NewThumbValue+ViewSize.
1183 45B4              ;
1184 45B4              ; This prevents the thumb from drawing outside the scroll bar or on
1185 45B4              ; the arrows.
1186 45B4              ;
1187 45B4              ;====================================================================
1188 45B4
1189 45B4 00 00        lastScrollTime DC W:0                   ;added 4-Jan-91 DAL
1190 45B6
1191 45B6                       EXPORT move_thumb 
1192 45B6              move_thumb  
1193 45B6              ;
1194 45B6              ; 4-Jan-91 DAL
1195 45B6              ;
1196 45B6              ; Max out the scrolling speed to a fixed amount of time.
1197 45B6              ; If it hasn't been minScrollDelay since the last time we
1198 45B6              ; moved the thumb, wait until it has.
1199 45B6              ;
1200 45B6 48                    pha                            ;space for result
1201 45B7 AF B4 48 02           lda   >lastScrollTime
1202 45BB 48                    pha   
1203 45BC F4 40 00              pea   MinScrollDelay
1204 45BF A2 03 3A 22           _WaitUntil 
1205 45C6 68                    pla   
1206 45C7 8F B4 48 02           sta   >lastScrollTime
1207 45CB              ;
1208 45CB              ;--- Validate the new value -----------------------------------------
1209 45CB              ;
1210 45CB A0 1E 00              ldy   #Ctldata+2               ; compute maximum allowable value
1211 45CE B7 05                 lda   [<CtlPtr],y              ; as Max-View
1212 45D0 88                    dey   
1213 45D1 88                    dey   
1214 45D2 38                    sec   
1215 45D3 F7 05                 sbc   [<CtlPtr],y
1216 45D5 C5 29                 cmp   param                    ; look at new value
1217 45D7 B0 09                 bcs   @MaxOK
1218 45D9 B7 05                 lda   [<CtlPtr],y              ; compute new max as Value+View.
1219 45DB 18                    clc   
1220 45DC 65 29                 adc   param
1221 45DE C8                    iny   
1222 45DF C8                    iny   
1223 45E0 97 05                 sta   [<CtlPtr],y
1224 45E2              @MaxOK    
1225 45E2
1226 45E2
1227 45E2              ;
1228 45E2 20 4C 49              jsr   new_thumb                Compute new thumber.
1229 45E5              ;
1230 45E5 20 10 4A              jsr   scrollState              Is scroll bar drawable?
1231 45E8 B0 61                 bcs   exit1
1232 45EA              ;
1233 45EA              ;
1234 45EA              ; ------- Compute area of old thumber needing to be erased ---------
1235 45EA              ;
1236 45EA A0 2E 00              ldy   #Thumb+x2
1237 45ED 20 28 38              jsr   CMsetrect2               Get rect of new thumber position.
1238 45F0              ;
1239 45F0 20 42 4A              jsr   SetUpColor
1240 45F3
1241 45F3 A6 2D                 ldx   <offset
1242 45F5 B5 15                 lda   <rect+y1,x
1243 45F7 D5 35                 cmp   <trect+y1,x
1244 45F9 F0 2A                 beq   noerase
1245 45FB 90 08                 bcc   skip2
1246 45FD D5 39                 cmp   <trect+y2,x
1247 45FF B0 0C                 bcs   erase
1248 4601 95 39                 sta   <trect+y2,x
1249 4603 80 08                 bra   erase
1250 4605              ;
1251 4605 B5 19        skip2    lda   <rect+y2,x
1252 4607 D5 35                 cmp   <trect+y1,x
1253 4609 90 02                 bcc   erase
1254 460B 95 35                 sta   <trect+y1,x
1255 460D              ;
1256 460D              ;
1257 460D              erase                                   ;
1258 460D              ;
1259 460D A9 35 00              lda   #trect                   Pass address of rect to FillRect.
1260 4610 20 F5 36              jsr   pushzpage
1261 4613              ;
1262 4613 A0 0C 00              ldy   #PageRgnColor            Page region pattern and color.
1263 4616 B7 11                 lda   [<colorptr],y
1264 4618 A8                    tay   
1265 4619 20 21 3E              jsr   set_patt
1266 461C DA                    phx                            Pass address of pattern.
1267 461D 5A                    phy   
1268 461E A2 04 57 22           _FillRect                      Erase thumber.
1269 4625              ;
1270 4625              noerase                                 ;
1271 4625              ;
1272 4625              ;
1273 4625              ; ------- Draw new thumber -------------------------------------
1274 4625              ;
1275 4625 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1276 4628 A2 00 00              ldx   #0                       Normal falg.
1277 462B A0 11 00              ldy   #CtlHilite               Is thumb highlighted?
1278 462E B7 05                 lda   [<Ctlptr],y
1279 4630 29 FF 00              and   #$00FF
1280 4633 C9 81 00              cmp   #THUMB_PART
1281 4636 D0 02                 bne   store
1282 4638 E8                    inx   Selected.
1283 4639 E8                    inx   
1284 463A A0 50 00     store    ldy   #state
1285 463D 8A                    txa   
1286 463E 97 41                 sta   [<data],y
1287 4640 A0 4E 00              ldy   #active                  Must be active.
1288 4643 A9 00 00              lda   #0
1289 4646 97 41                 sta   [<data],y
1290 4648              ;
1291 4648 20 9C 47              jsr   draw_thumb               Draw thumber in new position.
1292 464B
1293 464B 60           exit1    rts   
1294 464C
1295 464C
1296 464C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1297 464C              ;        Given a new value, compute new thumber for scroll bar.
1298 464C              ;
1299 464C              ;   IN:  Ctlptr = pointer to scroll bar.
1300 464C              ;
1301 464C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1302 464C                       EXPORT new_thumb 
1303 464C              new_thumb                               ;
1304 464C              ;
1305 464C              ;
1306 464C 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1307 464F A2 00 00              ldx   #0                       Offset for vertical scroll bar.
1308 4652 A0 10 00              ldy   #CtlFlag
1309 4655 B7 05                 lda   [<Ctlptr],y
1310 4657 29 10 00              and   #DIR_SCROLL
1311 465A F0 02                 beq   store1
1312 465C E8                    inx   
1313 465D E8                    inx                            Offset for horizontal scroll bar.
1314 465E 86 2D        store1   stx   <offset
1315 4660              ;
1316 4660              ;
1317 4660              ; --- Remember the old thumber ---------------------------
1318 4660              ;
1319 4660 A0 36 00              ldy   #PageRegion+x2
1320 4663 20 28 38              jsr   CMsetrect2               rect = page region.
1321 4666              ;
1322 4666 20 F2 36              jsr   pushrect
1323 4669 20 E4 36              jsr   pushVvert_pen
1324 466C F4 01 00              pea   1
1325 466F A2 04 4C 22           _InsetRect 
1326 4676              ;
1327 4676 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1328 4679              ;
1329 4679 A6 2D                 ldx   <offset
1330 467B B5 15                 lda   <rect,x
1331 467D 85 31                 sta   <front                   Front side of page region.
1332 467F              ;
1333 467F B5 19                 lda   <rect+y2,x               Compute height of page region.
1334 4681 38                    sec   
1335 4682 F5 15                 sbc   <rect,x
1336 4684 85 2F                 sta   <height
1337 4686              ;
1338 4686              ;
1339 4686              ; --- Compute new RECT for thumber ----------------------------------
1340 4686              ;
1341 4686 A0 2E 00              ldy   #Thumb+x2
1342 4689 20 28 38              jsr   CMsetrect2               rect = thumber.
1343 468C              ;
1344 468C A2 06 00              ldx   #x2                      Save current thumber rect.
1345 468F B5 15        lop2     lda   <rect,x
1346 4691 95 35                 sta   <trect,x
1347 4693 CA                    dex   
1348 4694 CA                    dex   
1349 4695 10 F8                 bpl   lop2
1350 4697              ;
1351 4697              ;
1352 4697              ; ------- Get size of thumber ----------------------------------------
1353 4697              ;
1354 4697 A0 1C 00              ldy   #CtlData                 op1 = view size.
1355 469A B7 05                 lda   [<Ctlptr],y
1356 469C AA                    tax                            op1 = view size.
1357 469D C8                    iny   
1358 469E C8                    iny   
1359 469F B7 05                 lda   [<Ctlptr],y              op3 = total size of data area.
1360 46A1 A4 2F                 ldy   <height                  op2 = size of page region.
1361 46A3 20 CF 3D              jsr   fraction
1362 46A6              ;
1363 46A6              ;
1364 46A6              ; ------ Check minimum thumb size --------------------------------
1365 46A6              ;
1366 46A6 8A                    txa   
1367 46A7 A6 2D                 ldx   <offset                  Horizontal or Vertical scroll bar?
1368 46A9 F0 09                 beq   ck_vermin
1369 46AB              ;
1370 46AB A0 4C 00              ldy   #min_thumb
1371 46AE D7 41                 cmp   [<data],y                Minimum thumber size.
1372 46B0 B0 0A                 bcs   store3
1373 46B2 B7 41                 lda   [<data],y                (Let it fall through, always 8 or more.)
1374 46B4              ;
1375 46B4 C9 08 00     ck_vermin cmp   #8
1376 46B7 B0 03                 bcs   store3
1377 46B9 A9 08 00              lda   #8
1378 46BC              ;
1379 46BC 85 33        store3   sta   <thumb_h                 Number of pixels in thumber.
1380 46BE              ;
1381 46BE              ;
1382 46BE              ;
1383 46BE A5 2F                 lda   <height                  Shrink page region by thumber size.
1384 46C0 38                    sec   
1385 46C1 E5 33                 sbc   <thumb_h
1386 46C3 85 2F                 sta   <height
1387 46C5              ;
1388 46C5              ;
1389 46C5              ; ------- Get starting position of thumber first --------------------
1390 46C5              ;
1391 46C5 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1392 46C8 A0 12 00              ldy   #CtlValue
1393 46CB B7 05                 lda   [<Ctlptr],y
1394 46CD AA                    tax                            op1 = current value.
1395 46CE A0 1E 00              ldy   #CtlData+2
1396 46D1 B7 05                 lda   [<Ctlptr],y
1397 46D3 88                    dey   
1398 46D4 88                    dey   
1399 46D5 38                    sec   
1400 46D6 F7 05                 sbc   [<Ctlptr],y              op3 = data size - view size.
1401 46D8 A4 2F                 ldy   <height                  op2 = page height - thumb height.
1402 46DA 20 CF 3D              jsr   fraction
1403 46DD DA                    phx                            Number of pixels in front of thumber.
1404 46DE              ;
1405 46DE              ;
1406 46DE              ; ------- Update thumber rect ----------------------------------------
1407 46DE              ;
1408 46DE 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1409 46E1 A9 28 00              lda   #Thumb
1410 46E4 18                    clc   
1411 46E5 65 2D                 adc   <offset
1412 46E7 A8                    tay   
1413 46E8              ;
1414 46E8 68                    pla                            Number of pixels in front of thumber.
1415 46E9 18                    clc   
1416 46EA 65 31                 adc   <front
1417 46EC 97 05                 sta   [<Ctlptr],y
1418 46EE C8                    iny   
1419 46EF C8                    iny   
1420 46F0 C8                    iny   
1421 46F1 C8                    iny   
1422 46F2 18                    clc   
1423 46F3 65 33                 adc   <thumb_h
1424 46F5 97 05                 sta   [<Ctlptr],y
1425 46F7              ;
1426 46F7 60                    rts   
1427 46F8
1428 46F8                       ENDP 
1429 46F8
1430 46F8
1431 46F8              ;====================================================================
1432 46F8              ;
1433 46F8              ;          Move scroll bar.
1434 46F8              ;
1435 46F8              ;   IN:    param = delta y.
1436 46F8              ;          param+2 = delta x.
1437 46F8              ;
1438 46F8              ;  OUT:    offset page and thumb RECTs.
1439 46F8              ;
1440 46F8              ;====================================================================
1441 46F8              move_bar proc EXPORT 
1442 46F8
1443 46F8 A9 28 00              lda   #Thumb                   Offset thumber.
1444 46FB 20 01 4A              jsr   offsetRect
1445 46FE              ;
1446 46FE A9 30 00              lda   #PageRegion              Offset page region.
1447 4701              ;
1448 4701 20 D7 3C     offsetRect jsr   pushrecord
1449 4704 D4 2B                 pei   <param+2                 Pass delta x.
1450 4706 D4 29                 pei   <param                   Pass delta y.
1451 4708 A2 04 4B 22           _OffsetRect                    Move the enclosing RECT.
1452 470F              ;
1453 470F 60                    rts   
1454 4710
1455 4710                       ENDP 
1456 4710
1457 4710
1458 4710              ;====================================================================
1459 4710              ;
1460 4710              ;          Test to draw control.
1461 4710              ;
1462 4710              ;  OUT:    Carry set if control is invisible, inactive, or view >= data.
1463 4710
1464 4710              ;====================================================================
1465 4710              scrollState proc EXPORT 
1466 4710
1467 4710 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1468 4713 A0 1C 00              ldy   #CtlData
1469 4716 B7 05                 lda   [<Ctlptr],y              Total view.
1470 4718 C8                    iny   
1471 4719 C8                    iny   
1472 471A D7 05                 cmp   [<Ctlptr],y              Total data area.
1473 471C B0 13                 bcs   exit                     Everything in view?
1474 471E
1475 471E 38                    sec                            Don't draw flag.
1476 471F              ;
1477 471F A0 10 00              ldy   #CtlFlag
1478 4722 B7 05                 lda   [<Ctlptr],y
1479 4724 29 80 00              and   #Ctl_INVIS               Is the scroll bar visible?
1480 4727 D0 08                 bne   exit
1481 4729              ;
1482 4729 A0 4E 00              ldy   #active
1483 472C B7 41                 lda   [<data],y
1484 472E 30 01                 bmi   exit
1485 4730 18                    clc   
1486 4731
1487 4731 60           exit     rts   
1488 4732
1489 4732                       ENDP 
1490 4732
1491 4732
1492 4732              ****************************************************************
1493 4732              *
1494 4732              CheckForVis PROC 
1495 4732              *
1496 4732              * This central routine checks the ctlFlag byte to see if
1497 4732              * the invisible bit is set.  If it is clear, the routine
1498 4732              * returns to the calling routine.
1499 4732              *
1500 4732              * If the bit is set, this routine pops an extra word off
1501 4732              * the stack and returns to the routine that called 
1502 4732              * the calling routine.
1503 4732              *
1504 4732              *
1505 4732              * Inputs:
1506 4732              *                   <ctlPtr
1507 4732              *
1508 4732              * Outputs:
1509 4732              *                   returns or not
1510 4732              *
1511 4732              * External Refs:
1512 4732              *                   none
1513 4732              *
1514 4732              * Entry Points:
1515 4732              *                   none
1516 4732              *
1517 4732                       longa on                       ; mode
1518 4732                       longi on 
1519 4732              *
1520 4732              ****************************************************************
1521 4732
1522 4732
1523 4732 A0 10 00              ldy   #CtlFlag                 Read the flag
1524 4735 B7 05                 lda   [<Ctlptr],y
1525 4737
1526 4737 89 80 00              bit   #ctl_invis               Are we visible?
1527 473A F0 05                 beq   @GoOn                    Yes, go on
1528 473C A9 00 00              lda   #0                       Quit now.
1529 473F AA                    tax   
1530 4740 7A                    ply                            Pull off extra RTS and go back to Ctl Mgr
1531 4741 60           @GoOn    rts   
1532 4742
1533 4742                       ENDP 
1534 4742
1535 4742
1536 4742
1537 4742
1538 4742              ****************************************************************
1539 4742              *
1540 4742              SetUpColor PROC 
1541 4742              *
1542 4742              * Sets up colorPtr.
1543 4742              *
1544 4742              *
1545 4742              * In:    CtlHandle
1546 4742              *        CtlPtr
1547 4742              *
1548 4742              * Out:   ColorPtr
1549 4742              * 
1550 4742              *
1551 4742              * External Refs:
1552 4742              *                   none
1553 4742              *
1554 4742              * Entry Points:
1555 4742              *                   none
1556 4742              *
1557 4742                       longa on                       ; mode
1558 4742                       longi on 
1559 4742              *
1560 4742              * Change History
1561 4742              *
1562 4742              * 19 Feb 89         Steven Glass
1563 4742              *
1564 4742              * This used to be part of ControlMgr.asm.  Now it is part
1565 4742              * of DefProcs.  The change was made because the color table
1566 4742              * ref was being made and memory manager calls could make
1567 4742              * it move.  It was also being made too often.
1568 4742              *
1569 4742              ****************************************************************
1570 4742
1571 4742              ;
1572 4742              ;-----------------------------------------------------------
1573 4742              ;
1574 4742              ; Start by copying the reference from the control record
1575 4742              ; to ColorPtr.  Who knows, it may even be right.
1576 4742              ;
1577 4742 A0 24 00              ldy   #CtlColor                Set pointer to the color table.
1578 4745 B7 05                 lda   [<Ctlptr],y
1579 4747 85 11                 sta   <colorptr
1580 4749 C8                    iny   
1581 474A C8                    iny   
1582 474B B7 05                 lda   [<Ctlptr],y
1583 474D 85 13                 sta   <colorptr+2
1584 474F
1585 474F
1586 474F              ;
1587 474F              ; If the control is not a super control, we are done.
1588 474F              ;
1589 474F A0 16 00              ldy   #NewCtlRecord.ctlProc+2
1590 4752 B7 05                 lda   [ctlPtr],y
1591 4754 10 2E                 bpl   @Done
1592 4756
1593 4756              ;
1594 4756              ; It is a super control.  See what the verb is.
1595 4756              ;
1596 4756 20 1B 3E              jsr   ReadMoreFlags
1597 4759 29 0C 00              and   #ColorTableVerbMask
1598 475C F0 26                 beq   @Done                    0 is pointer so all done
1599 475E
1600 475E C9 04 00              cmp   #ColorTableIsHandle
1601 4761 F0 15                 beq   @IsHandle
1602 4763
1603 4763              @IsResource  
1604 4763 48                    pha   
1605 4764 48                    pha   
1606 4765 F4 0D 80              PushWord #rCtlColorTable 
1607 4768 D4 13                 pei   ColorPtr+2
1608 476A D4 11                 pei   ColorPtr
1609 476C 20 E7 35              jsr   LoadResource
1610 476F 68                    pla   
1611 4770 85 11                 sta   ColorPtr
1612 4772 68                    pla   
1613 4773 85 13                 sta   ColorPtr+2
1614 4775
1615 4775              ;
1616 4775              ; memory may have moved, so reset ctlPtr
1617 4775              ;
1618 4775 20 02 37              jsr   Dereference
1619 4778
1620 4778              @IsHandle  
1621 4778
1622 4778 A0 02 00              ldy   #2
1623 477B B7 11                 lda   [ColorPtr],y
1624 477D AA                    tax   
1625 477E A7 11                 lda   [ColorPtr]
1626 4780 85 11                 sta   ColorPtr
1627 4782 86 13                 stx   ColorPtr+2
1628 4784
1629 4784              @Done     
1630 4784 60                    rts   
1631 4785
1632 4785
1633 4785                       ENDP 
1634 4785
1635 4785
1636 4785                       END   
